/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.animations;

import com.mlib.Utility;
import com.mlib.animations.Frame;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;

public class Animation<Type> {
    final TreeMap<Float, Frame<Type>> frames = new TreeMap();
    final float step;

    public Animation(int ticks) {
        this.step = 1.0f / (float)ticks;
    }

    public Animation(double seconds) {
        this(Utility.secondsToTicks(seconds));
    }

    public static void applyRotationInDegrees(Vector3f value, ModelPart ... modelParts) {
        for (ModelPart modelPart : modelParts) {
            value.m_122261_((float)Math.PI / 180);
            modelPart.m_171327_(value.m_122239_(), value.m_122260_(), value.m_122269_());
        }
    }

    public static void applyPosition(Vector3f value, ModelPart ... modelParts) {
        for (ModelPart modelPart : modelParts) {
            modelPart.m_104227_(value.m_122239_(), value.m_122260_(), value.m_122269_());
        }
    }

    public static void addPosition(Vector3f value, ModelPart ... modelParts) {
        for (ModelPart modelPart : modelParts) {
            modelPart.m_104227_(modelPart.f_104200_ + value.m_122239_(), modelPart.f_104201_ + value.m_122260_(), modelPart.f_104202_ + value.m_122269_());
        }
    }

    public static void applyScale(float value, ModelPart ... modelParts) {
        for (ModelPart modelPart : modelParts) {
            modelPart.f_233553_ = value;
            modelPart.f_233554_ = value;
            modelPart.f_233555_ = value;
        }
    }

    public Animation<Type> add(float duration, Frame<Type> frame) {
        this.frames.put(Float.valueOf(duration), frame);
        return this;
    }

    public Type apply(float duration, float ageInTicks) {
        duration = Mth.m_14036_((float)duration, (float)this.frames.firstKey().floatValue(), (float)this.frames.lastKey().floatValue());
        Map.Entry<Float, Frame<Type>> current = this.frames.floorEntry(Float.valueOf(duration));
        Map.Entry<Float, Frame<Type>> next = this.frames.ceilingEntry(Float.valueOf(duration));
        if (!Objects.equals(current.getKey(), next.getKey())) {
            float ratio = (duration + ageInTicks % 1.0f * this.step - current.getKey().floatValue()) / (next.getKey().floatValue() - current.getKey().floatValue());
            return current.getValue().interpolate(Math.min(ratio, 1.0f), next.getValue());
        }
        return next.getValue().getValue();
    }

    public record Applier(float duration, float ageInTicks) {
        public static Applier setup(float duration, float ageInTicks) {
            return new Applier(duration, ageInTicks);
        }

        public <Type> Applier apply(Animation<Type> animation, BiConsumer<Type, ModelPart[]> consumer, ModelPart ... modelParts) {
            consumer.accept(animation.apply(this.duration, this.ageInTicks), modelParts);
            return this;
        }
    }
}

